using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data;
using MySql.Data.MySqlClient;

public partial class Try_catch_finally : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        // When the page loads we get data from session variables to us in our SELECT statements.
        if (!Page.IsPostBack)
        {
            HiddenCompanyID.Value = Convert.ToString(Session["CompanyID"]);
        }
    }

    protected void btnGetData_Click(object sender, EventArgs e)
    {
        
        // We declare two variables that will be used to "SELECT" data from a table in a database.
        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string sql = "SELECT Place, AssetOwnID, AssetName, VerNumber, Supplier FROM Assets WHERE CompanyID = "
        + "@CompanyID AND SoldScraped = '0' ORDER BY Place";

        // We declare cn as a new instance of the MySQLConnection class and supplies "ConnString" as a parameter.
        // MySqlConnection has a dispose and a close method, they are doing the same thing so we only need to call
        // one of them when we are finished with the object. We are going to call close in the "Finally" block
        // to be sure that the close method will be called even if there is an exception.
        MySqlConnection cn = new MySqlConnection(ConnString);

        // We declare cmd as a new instance of the MySqlCommand class and suppliy "sql" and "cn" as a parameters.
        // MySqlCommand has a dispose method. We are going to call dispose in the "Finally" block
        // to be sure that the dispose method will be called even if there is an exception.
        MySqlCommand cmd = new MySqlCommand(sql, cn);

        // We declare reader as a MySqlDataReader object. MySqlDataReader has a close method and we are going 
        // to call close in the "Finally" block to be sure that the close method will be called even if there 
        // is an exception.
        MySqlDataReader reader = null;

        // We include structured error handling by creating a "Try" block, by putting the application code
        // inside the "Try" block and by including two "Catch" blocks.
        try
        {
            // We add a parameter to be used in the "SELECT" statement.
            cmd.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);

            // We open the connection to the database.
            cn.Open();

            // We put the data from the "SELECT" statement in the reader variable. 
            reader = cmd.ExecuteReader();

            // This code binds the data in the reader variable to the repeater control in the web form.
            SelectToRepeaterDataReader.DataSource = reader;
            SelectToRepeaterDataReader.DataBind();
        }
        catch (MySqlException sqlEx)
        {
            // Catch a specific exception, a MySqlException
            Response.Write(sqlEx.Message);
        }
        catch (Exception ex)
        {
            // Catch a general exception to include all the exceptions that dont are MySqlExceptions.
            Response.Write(ex.Message);
        }
        finally
        {
            // Dispose of objects even if there will be an exception in the "Try" block. The dispose methods are
            // designed so that you can call them how many times you want even if there isnt a object to dispose.

            // Close the MySqlConnection object
            cn.Close();

            // Dispose of the MySqlCommand object
            cmd.Dispose();

            // Close the MySqlDataReader object if it not is null.
            if (reader != null)
                reader.Close();

        }

        // //////////////////////////////////////////////////////////////////////////////////////////////////////
        // AN ALTERNATIVE WAY TO CODE A TRY/CATCH/FINALLY BLOCK WITH THE "USING" STATEMENT
        // //////////////////////////////////////////////////////////////////////////////////////////////////////
        //try
        //{
        //    string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        //    string sql = "SELECT Place, AssetOwnID, AssetName, VerNumber, Supplier FROM Assets WHERE "
        //    + "CompanyID = @CompanyID AND SoldScraped = '0' ORDER BY Place";

        //    // The using block is used to call dispose (close) automatically even if there are an exception.
        //    using (MySqlConnection cn = new MySqlConnection(ConnString))
        //    {
        //        using (MySqlCommand cmd = new MySqlCommand(sql, cn))
        //        {
        //            cmd.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);

        //            cn.Open();

        //            // The using block is used to call dispose (close) automatically even if there are an exception.
        //            using (MySqlDataReader reader = cmd.ExecuteReader())
        //            {
        //                SelectToRepeaterDataReader.DataSource = reader;
        //                SelectToRepeaterDataReader.DataBind();
        //            }
        //        }
        //    }
        //}
        //catch (MySqlException sqlEx)
        //{
        //    // Throw a specific exception, a MySqlException
        //    throw new Exception("MySpecificException", sqlEx);
        //}
        //catch (Exception ex)
        //{
        //    // Throw a general exception to include all the exceptions that dont are MySqlExceptions.
        //    throw new Exception("MyGeneralException", ex);

        //}
    }
}
